﻿using System;
using Microsoft.VisualStudio.TestTools.UnitTesting;

using KoloryWPF.Model;
using KoloryWPF.ModelWidoku;

namespace TestyJednostkowe.ModelWidoku
{
    [TestClass]
    public class EdycjaKoloruTesty
    {
        [TestMethod]
        public void TestKonstruktora()
        {
            EdycjaKoloru ek = new EdycjaKoloru();

            Assert.AreEqual(0, ek.R, "Niezgodność dotyczy własności R");
            Assert.AreEqual(128, ek.G, "Niezgodność dotyczy własności G");
            Assert.AreEqual(255, ek.B, "Niezgodność dotyczy własności B");
        }

        private const int liczbaPowtórzeń = 100000;        
        private Random rnd = new Random();

        public void TestPoleceniaZapisz()
        {
            for (int i = 0; i < liczbaPowtórzeń; i++)
            {
                byte[] składoweKoloru = new byte[3];
                rnd.NextBytes(składoweKoloru);

                EdycjaKoloru ek = new EdycjaKoloru();
                ek.R = składoweKoloru[0];
                ek.G = składoweKoloru[1];
                ek.B = składoweKoloru[2];

                Assert.IsTrue(ek.Zapisz.CanExecute(null));
                ek.Zapisz.Execute(null);
                Assert.AreEqual(ek.R, Ustawienia.r);
                Assert.AreEqual(ek.G, Ustawienia.g);
                Assert.AreEqual(ek.B, Ustawienia.b);
            }
        }

        [TestMethod]
        public void TestPoleceniaResetuj()
        {
            EdycjaKoloru ek = new EdycjaKoloru();

            Assert.IsTrue(ek.Resetuj.CanExecute(null), "Niezgodność dotyczy metody CanExecute wywołanej przed zresetowaniem");
            ek.Resetuj.Execute(null);
            Assert.AreEqual(0, ek.R, "Niezgodność dotyczy własności R");
            Assert.AreEqual(0, ek.G, "Niezgodność dotyczy własności G");
            Assert.AreEqual(0, ek.B, "Niezgodność dotyczy własności B");
            Assert.IsFalse(ek.Resetuj.CanExecute(null), "Niezgodność dotyczy metody CanExecute wywołanej po zresetowaniu");
        }
    }
}
